<?php
session_start();
require 'db.php';

if (!isset($_SESSION['user_id'])) { header("Location: index.php"); exit; }

$user_id = $_SESSION['user_id'];

// Ambil event
$query = "SELECT * FROM events ORDER BY date ASC";
$result = mysqli_query($conn, $query);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tiket Saya - Titik Kumpul</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>

    <div class="mobile-container">
        
        <div class="header-home" style="border-bottom: 1px solid #eee; padding-bottom: 15px; margin-bottom: 15px;">
            <a href="home.php" style="text-decoration:none; color: #333; font-size:18px;">
                <i class="fa-solid fa-arrow-left"></i>
            </a>
            <h3 style="font-size: 18px; margin: 0;">Tiket Saya</h3>
            <div style="width: 20px;"></div> 
        </div>

        <div class="p-20" style="padding-top: 0; padding-bottom: 100px;">
            
            <?php 
            if (mysqli_num_rows($result) > 0) {
                while($row = mysqli_fetch_assoc($result)) {
                    $d = new DateTime($row['date']);
                    $dateStr = $d->format('d M Y');
                    $timeStr = $d->format('H:i');
                    $statusClass = ($row['type'] == 'Required') ? 'status-req' : 'status-opt';
                    $qrData = $user_id . '-' . $row['id'];
            ?>

            <div class="ticket-card">
                <div class="ticket-info">
                    <div class="ticket-title"><?= $row['title']; ?></div>
                    <div class="ticket-meta">
                        <i class="fa-regular fa-calendar"></i> <?= $dateStr; ?> • <?= $timeStr; ?>
                    </div>
                    <div class="ticket-meta">
                        <i class="fa-solid fa-location-dot"></i> <?= $row['location']; ?>
                    </div>
                    <span class="badge <?= ($row['type'] == 'Required') ? 'badge-req' : 'badge-opt'; ?>" style="margin-top: 5px;">
                        <?= $row['type']; ?>
                    </span>
                </div>

                <div class="ticket-action" onclick="openModal('<?= addslashes($row['title']); ?>', '<?= $dateStr; ?>', '<?= $timeStr; ?>', '<?= $qrData; ?>')">
                    <i class="fa-solid fa-qrcode"></i>
                    <span>SCAN</span>
                </div>
            </div>

            <?php 
                } 
            } else {
                echo '<div style="text-align:center; color:#888; margin-top:50px;">Belum ada event.</div>';
            }
            ?>
        </div>

        <div class="bottom-nav">
            <a href="home.php" class="nav-item">
                <i class="fa-solid fa-house"></i>
                Home
            </a>
            <a href="view_full_event.php" class="nav-item">
                <i class="fa-solid fa-book-open"></i>
                Event
            </a>
            <a href="barcode.php" class="nav-item active">
                <i class="fa-solid fa-qrcode"></i>
                Barcode
            </a>
        </div>

    </div>

    <div id="modalOverlay" class="modal-overlay" onclick="closeModal(event)">
        <div class="modal-card">
            <div class="modal-header">
                SCAN QR CODE
                <i class="fa-solid fa-xmark close-icon" onclick="forceClose()"></i>
            </div>
            <div class="modal-body">
                <div style="background: #f8f9fa; padding: 10px; border-radius: 8px; margin-bottom: 15px; text-align: left;">
                    <h3 id="mTitle" style="font-size: 16px; margin: 0 0 5px 0;">Event</h3>
                    <p style="font-size: 12px; color: #666; margin:0;"><span id="mDate">Date</span> • <span id="mTime">Time</span></p>
                </div>
                
                <div style="border: 1px dashed #ccc; padding: 10px; display: inline-block; border-radius: 10px;">
                    <img id="mQR" src="" alt="QR" style="width: 180px; height: 180px; display: block;">
                </div>
                
                <p style="font-size: 11px; color: #888; margin-top: 15px;">
                    Tunjukkan ke panitia saat masuk.
                </p>
            </div>
        </div>
    </div>

    <script>
        const overlay = document.getElementById('modalOverlay');
        const mTitle = document.getElementById('mTitle');
        const mDate = document.getElementById('mDate');
        const mTime = document.getElementById('mTime');
        const mQR = document.getElementById('mQR');

        function openModal(title, date, time, qrData) {
            mTitle.innerText = title;
            mDate.innerText = date;
            mTime.innerText = time;
            mQR.src = `https://api.qrserver.com/v1/create-qr-code/?size=250x250&data=${qrData}`;
            overlay.style.display = 'flex';
        }

        function forceClose() { overlay.style.display = 'none'; }
        function closeModal(e) { if (e.target === overlay) overlay.style.display = 'none'; }
    </script>
</body>
</html>