<?php
// Pastikan session sudah start di file induk, tapi untuk jaga-jaga cek user
if (!isset($user)) {
    // Jika $user belum didefinisikan dari file induk, ambil dari session
    $name = isset($_SESSION['name']) ? explode(' ', $_SESSION['name'])[0] : 'Guest';
    $position = isset($_SESSION['position']) ? $_SESSION['position'] : 'Member';
} else {
    $name = explode(' ', $user['name'])[0];
    $position = $user['position'];
}
?>

<style>
    /* CSS SIDEBAR MOBILE STYLE */
    
    /* Overlay Gelap di belakang sidebar */
    .sidebar-overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5);
        z-index: 1999; /* Di bawah sidebar, di atas konten */
        display: none; /* Default sembunyi */
        backdrop-filter: blur(2px);
        transition: opacity 0.3s;
    }
    
    .sidebar-overlay.active {
        display: block;
        animation: fadeIn 0.3s;
    }

    /* Sidebar Drawer */
    .sidebar {
        height: 100%;
        width: 280px; /* Lebar Sidebar */
        max-width: 80%; /* Agar tidak terlalu lebar di HP kecil */
        position: absolute; /* Absolute terhadap .mobile-container */
        z-index: 2000 ;
        top: 0;
        left: -100%; /* Sembunyi total ke kiri */
        background-color: #ffffff;
        color: #333;
        transition: left 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        display: flex;
        flex-direction: column;
        box-shadow: 5px 0 15px rgba(0,0,0,0.1);
        border-right: 1px solid #f0f0f0;
    }

    .sidebar.open {
        left: 0; /* Muncul */
    }

    /* Header Sidebar */
    .sidebar-header {
        padding: 25px 20px;
        background: var(--primary-gradient); /* Ikut style.css */
        color: white;
        display: flex;
        justify-content: space-between;
        align-items: center;
        border-bottom-right-radius: 20px;
    }

    .sidebar-header h3 { margin: 0; font-size: 18px; font-weight: 600; }
    .sidebar-header p { margin: 0; font-size: 12px; opacity: 0.9; }

    /* Menu List */
    .sidebar-menu {
        padding: 20px 0;
        flex-grow: 1; /* Isi ruang kosong */
        overflow-y: auto;
    }
    
    .sidebar a {
        padding: 15px 25px;
        text-decoration: none;
        font-size: 14px;
        color: #555;
        display: flex;
        align-items: center;
        gap: 15px;
        transition: 0.2s;
        border-left: 4px solid transparent;
        font-weight: 500;
    }

    .sidebar a i {
        width: 20px;
        text-align: center;
        font-size: 16px;
        color: #888;
    }

    /* Hover & Active State */
    .sidebar a:hover, .sidebar a.active {
        background-color: #f8f9fa;
        color: var(--primary); /* Warna Teal */
        border-left: 4px solid var(--primary);
    }
    
    .sidebar a:hover i, .sidebar a.active i {
        color: var(--primary);
    }

    /* Footer Sidebar */
    .sidebar-footer {
        padding: 20px;
        border-top: 1px solid #eee;
        background-color: #fff;
    }

    .btn-logout-side {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        width: 100%;
        padding: 12px;
        background-color: #ffebee;
        color: #c62828 !important;
        border-radius: 12px;
        font-weight: 600;
        border: 1px solid #ef9a9a;
        transition: 0.2s;
    }
    
    .btn-logout-side:hover {
        background-color: #ffcdd2;
        border-left: none !important; /* Override style link biasa */
    }

    .close-btn {
        font-size: 24px;
        cursor: pointer;
        color: white;
        background: none;
        border: none;
        padding: 0;
    }

    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }
</style>

<div id="sidebarOverlay" class="sidebar-overlay" onclick="toggleSidebar()"></div>

<div id="mySidebar" class="sidebar">
    <div class="sidebar-header">
        <div>
            <h3>Titik Kumpul</h3>
            <p>Internal Ticketing</p>
        </div>
        <button class="close-btn" onclick="toggleSidebar()">×</button>
    </div>

    <div class="sidebar-menu">
        <?php $current_page = basename($_SERVER['PHP_SELF']); ?>
        
        <a href="home.php" class="<?php echo ($current_page == 'home.php') ? 'active' : ''; ?>">
            <i class="fa-solid fa-house"></i> Home
        </a>
        <a href="view_full_event.php" class="<?php echo ($current_page == 'view_full_event.php') ? 'active' : ''; ?>">
            <i class="fa-solid fa-calendar-days"></i> All Events
        </a>
        <a href="notification.php" class="<?php echo ($current_page == 'notification.php') ? 'active' : ''; ?>">
            <i class="fa-regular fa-bell"></i> Notifikasi
        </a>
        <a href="profile.php" class="<?php echo ($current_page == 'profile.php') ? 'active' : ''; ?>">
            <i class="fa-regular fa-user"></i> Profile
        </a>
    </div>

    <div class="sidebar-footer">
        <div style="margin-bottom: 15px; display:flex; align-items:center; gap:10px;">
            <div style="width:40px; height:40px; background:#eee; border-radius:50%; display:flex; justify-content:center; align-items:center; font-size:18px;">👤</div>
            <div>
                <div style="font-weight:bold; font-size:14px; color:#333;"><?php echo $name; ?></div>
                <div style="font-size:11px; color:#888;"><?php echo $position; ?></div>
            </div>
        </div>
        <a href="logout.php" class="btn-logout-side">
            <i class="fa-solid fa-right-from-bracket"></i> Logout
        </a>
    </div>
</div>

<script>
    function toggleSidebar() {
        document.getElementById("mySidebar").classList.toggle('open');
        document.getElementById("sidebarOverlay").classList.toggle('active');
    }
</script>